<%@ page language="java" buffer="none" contentType="text/html; charset=utf-8" %>
<%
    int nbSteps = 9;
%>
<html>
    <head>
        <title>Tests instructions</title>
        <script language="javascript">
            var custom_nbSteps = <%= nbSteps %>;
            var custom_stepsDone = new Array();
<%
    for(int s=1; s<=nbSteps; s++) {
%>
            custom_stepsDone[<%= s %>] = <%= request.getParameter("step" + s) %>;
<%
    }
%>

            function custom_load() {
                var nextStepFound = false;
                var stepId = "";
                for(var s=1; s<=custom_nbSteps; s++) {
                    stepId = "step" + s;
                    if (custom_stepsDone[s] == false) {
                        if (!nextStepFound) {
                            nextStepFound = true;
                            custom_setFontParameter(stepId, "font-size", "large");
                        } else
                            custom_setFontParameter(stepId, "font-weight", "bold");
                    }
                }
            }

            function custom_setFontParameter(objName, paramName, paramValue) {
                var obj = document.getElementById(objName);
                if (obj != null)
                    obj.style.cssText += ";" + paramName + ":" + paramValue + ";";
            }

        </script>
    </head>
    <body bgcolor="#ccccff" onload="custom_load()">
        <font size="3" color="#000099">
            <h1>Tests Instructions...</h1>
            <h3>Custom menus</h3>
            <ul id="Step1">
                <li>
Check that there is one custom menu with two sub-menu items. Select each of them.
                    <ul>
                        <li>
The first one should be disabled (nothing happens).
                        </li>
                        <li>
The second one should be enabled then the Test Instructions panel should be refreshed.
                        </li>
                    </ul>
                </li>
            </ul>
            <h3>Custom toolbar buttons</h3>
            <ul id="Step2">
                <li>
Check that there are two custom toolbar buttons : D and E buttons. Click on each of them.
                    <ul>
                        <li>
The first one (D) should be disabled (nothing happens).
                        </li>
                        <li>
The second one (E) should be enabled then the Test Instructions panel should be refreshed.
                        </li>
                    </ul>
                </li>
            </ul>
            <h3>Custom short cuts</h3>
            <ul id="Step3">
                <li>
Open short cuts settings panel through Settings menu item in Preferences menu. Then select short-cuts in the settings panel.
                </li>
                <li>
An Extended section should appear at the end of the table.
                </li>
                <li>
Configure the two custom shortcuts (with ctrl + shift + w and ctrl + shift + x for exemple).
                </li>
                <li>
Try the first shortcut, nothing should append because this shortcut is disabled.
                </li>
                <li>
Try the second shortcut, it should display the Test Instructions panel.
                </li>
            </ul>
            <h3>Interaction panels</h3>
            <ol>
                <li id="Step4">
Create a voice interaction through "File" menu or "New Phone Call" toolbar button.
                </li>
                <li id="Step5">
Enter a phone number and click connect button.
                </li>
                <li id="Step6">
Select the Resources button to display the Resources panel.
                </li>
                <li id="Step7">
Check that there are two custom action buttons in the interaction area : D and E buttons. Click on each of them.
                    <ul>
                        <li>
The first one (D) should be disabled (nothing happens).
                        </li>
                        <li>
The second one (E) should be enabled... the tests instructions in the custom resource tab then will be refreshed!!
                        </li>
                    </ul>
                </li>
                <li id="Step8">
Disconnect the call and mark done it.
                </li>
                <li id="Step9">
Logout from the Gad.
                </li>
            </ol>
        </font>
        <hr>
<%
    if (request.getParameter("close") == null) {
%>
        <input type="button" name="Button" value="Close" onclick="parent.closeCentralPanel('DISPLAY_TESTS_INSTRUCTIONS');">
<%
    }
%>
    </body>
</html>
